# Claude Code 開発ルール

## 🎯 このプロジェクトについて

**テンプレート種別**: Simple（シンプル）

用途：アイデア検証、プロトタイプ、LP、小規模サイト

このプロジェクトは、PC（Claude Desktop）とスマホ（Claudeアプリ）でシームレスに開発するための構成になっています。

---

## 📋 基本ルール

### ルール1：1セッション = 1機能

**必須：**
- 1回のセッションでは、1つの機能・タスクに集中する
- 複数の機能を依頼された場合は、優先順位を確認してから1つずつ対応

**例：**
```
❌ 悪い例：「ヘッダーとフッターとメインを作って」
✅ 良い例：「レスポンシブなヘッダーを作って。ロゴとナビゲーションを含めて」
```

---

### ルール2：セッション終了前に必ずコミット

**作業完了時の手順：**
1. 変更内容を確認
2. 適切なコミットメッセージでコミット
3. リモートにプッシュ
4. ユーザーに完了報告

**コミットメッセージ規約：**
```
feat: 新機能追加
fix: バグ修正
docs: ドキュメント更新
style: コードスタイル修正
refactor: リファクタリング
```

---

### ルール3：継続作業時のコンテキスト確認

スマホから継続する場合、または「続き」と言われた場合：

1. 現在のブランチとコミット履歴を確認
2. 直近の変更内容を要約して共有
3. 何を続けるか明確にしてから作業開始

---

### ルール4：作業開始時の状態報告

新しいセッション開始時に報告：
1. プロジェクトの現在の状態
2. 作成済みのページ/コンポーネント
3. 未完了のタスクがあれば報告

---

## 🛠️ 技術スタック

- **フレームワーク**: Next.js 14+ (App Router)
- **言語**: TypeScript
- **スタイリング**: Tailwind CSS
- **データベース**: なし（必要ならlocalStorage）
- **デプロイ**: Railway or Vercel

---

## 📁 プロジェクト構造

```
src/
├── app/              # Next.js App Router
│   ├── page.tsx      # トップページ
│   ├── layout.tsx    # 共通レイアウト
│   └── globals.css   # グローバルスタイル
└── components/       # UIコンポーネント
    ├── Header.tsx
    ├── Footer.tsx
    └── ...
```

---

## 🚀 開発コマンド

```bash
# 開発サーバー起動
npm run dev

# ビルド
npm run build

# 本番モードで起動
npm run start
```

---

## 📱 PC/スマホ連携

- **PC（Claude Desktop）**: レイアウト作成、スタイル調整
- **スマホ**: テキスト修正、軽微な変更

**重要**: セッション切り替え前に必ず `git push` すること！
