// ===========================================
// ユーザー関連
// ===========================================

export interface User {
  id: string;
  name: string | null;
  email: string;
  image: string | null;
  createdAt: Date;
}

export interface UserPublic {
  id: string;
  name: string | null;
  image: string | null;
}

// ===========================================
// 認証関連
// ===========================================

export interface LoginCredentials {
  email: string;
  password: string;
}

export interface RegisterData {
  name: string;
  email: string;
  password: string;
}

// ===========================================
// API関連（スマホアプリでも使用可能）
// ===========================================

export interface ApiSuccessResponse<T> {
  success: true;
  data: T;
}

export interface ApiErrorResponse {
  success: false;
  error: {
    code: string;
    message: string;
  };
}

export type ApiResponse<T> = ApiSuccessResponse<T> | ApiErrorResponse;

export interface PaginationInfo {
  page: number;
  perPage: number;
  total: number;
  totalPages: number;
}

export interface PaginatedResponse<T> {
  items: T[];
  pagination: PaginationInfo;
}

// ===========================================
// アプリケーション固有の型
// 以下は例です。プロジェクトに合わせて追加してください
// ===========================================

// export interface Post {
//   id: string;
//   title: string;
//   content: string | null;
//   published: boolean;
//   authorId: string;
//   author?: UserPublic;
//   createdAt: Date;
//   updatedAt: Date;
// }
