import Link from "next/link";
import { auth } from "@/lib/auth";

export default async function Home() {
  const session = await auth();

  return (
    <main className="min-h-screen flex flex-col items-center justify-center p-8">
      <div className="text-center">
        <h1 className="text-4xl font-bold mb-4">🚀 My App</h1>
        <p className="text-gray-600 mb-8">
          Next.js + PostgreSQL + NextAuth.js
        </p>

        {session ? (
          <div className="space-y-4">
            <p className="text-lg">
              ようこそ、<span className="font-semibold">{session.user?.name || session.user?.email}</span> さん
            </p>
            <Link
              href="/dashboard"
              className="inline-block px-6 py-3 bg-black text-white rounded-lg hover:bg-gray-800 transition"
            >
              ダッシュボードへ
            </Link>
          </div>
        ) : (
          <div className="flex gap-4 justify-center">
            <Link
              href="/login"
              className="px-6 py-3 bg-black text-white rounded-lg hover:bg-gray-800 transition"
            >
              ログイン
            </Link>
            <Link
              href="/register"
              className="px-6 py-3 border border-gray-300 rounded-lg hover:border-gray-400 transition"
            >
              新規登録
            </Link>
          </div>
        )}
      </div>
    </main>
  );
}
