import { redirect } from "next/navigation";
import { auth, signOut } from "@/lib/auth";

export default async function DashboardPage() {
  const session = await auth();

  if (!session) {
    redirect("/login");
  }

  return (
    <main className="min-h-screen p-8">
      <div className="max-w-4xl mx-auto">
        <header className="flex justify-between items-center mb-8">
          <h1 className="text-2xl font-bold">ダッシュボード</h1>
          <form
            action={async () => {
              "use server";
              await signOut({ redirectTo: "/" });
            }}
          >
            <button
              type="submit"
              className="px-4 py-2 text-sm border rounded-lg hover:bg-gray-50 transition"
            >
              ログアウト
            </button>
          </form>
        </header>

        <div className="bg-white border rounded-lg p-6">
          <h2 className="text-lg font-semibold mb-4">ユーザー情報</h2>
          <dl className="space-y-2">
            <div className="flex">
              <dt className="w-32 text-gray-500">名前</dt>
              <dd>{session.user?.name || "未設定"}</dd>
            </div>
            <div className="flex">
              <dt className="w-32 text-gray-500">メール</dt>
              <dd>{session.user?.email}</dd>
            </div>
          </dl>
        </div>

        <div className="mt-8 p-6 bg-gray-50 rounded-lg">
          <h2 className="text-lg font-semibold mb-2">🎉 認証成功！</h2>
          <p className="text-gray-600">
            ここから機能を追加していきましょう。
          </p>
        </div>
      </div>
    </main>
  );
}
