# プロジェクト名

> このREADMEはテンプレートです。プロジェクトに合わせて編集してください。

## 概要

プロジェクトの説明をここに書く

**このテンプレートの特徴：** 将来スマホアプリにも対応できるAPI設計

## 技術スタック

- **フレームワーク**: Next.js 14 (App Router)
- **言語**: TypeScript
- **スタイリング**: Tailwind CSS
- **データベース**: PostgreSQL (Railway)
- **ORM**: Prisma
- **認証**: NextAuth.js v5

## セットアップ

### 1. 依存関係インストール

```bash
npm install
```

### 2. 環境変数設定

```bash
cp .env.example .env
```

`.env` を編集してデータベースURLなどを設定

### 3. データベースセットアップ

```bash
npx prisma migrate dev
npx prisma studio  # オプション
```

### 4. 開発サーバー起動

```bash
npm run dev
```

http://localhost:3000 でアクセス

## API設計

### バージョニング

すべてのAPIは `/api/v1/` プレフィックスを使用：

```
GET  /api/v1/users      # ユーザー一覧
GET  /api/v1/users/:id  # ユーザー詳細
POST /api/v1/users      # ユーザー作成
```

### レスポンス形式

**成功時：**
```json
{
  "success": true,
  "data": { ... }
}
```

**エラー時：**
```json
{
  "success": false,
  "error": {
    "code": "ERROR_CODE",
    "message": "エラーメッセージ"
  }
}
```

## スマホアプリ拡張

将来React Native等でアプリを作る場合：

1. `/api/v1/` のAPIをそのまま使用
2. `src/types/` の型定義を共有
3. 認証はJWTトークンで連携

```
┌─────────────┐     ┌─────────────┐
│   Web App   │     │ Mobile App  │
└──────┬──────┘     └──────┬──────┘
       │                   │
       └───────┬───────────┘
               │
        ┌──────▼──────┐
        │   /api/v1/   │
        └──────┬──────┘
               │
        ┌──────▼──────┐
        │ PostgreSQL  │
        └─────────────┘
```

## ディレクトリ構成

```
src/
├── app/
│   ├── api/
│   │   ├── auth/      # 認証API
│   │   └── v1/        # バージョン管理されたAPI
│   ├── (auth)/        # 認証ページ
│   └── (main)/        # メインページ
├── components/        # コンポーネント
├── lib/              # ユーティリティ
│   ├── api-response.ts  # API共通レスポンス
│   ├── auth.ts       # NextAuth設定
│   └── db.ts         # Prismaクライアント
└── types/            # 型定義（Web/アプリ共有可能）

prisma/
├── schema.prisma
└── migrations/
```

## デプロイ（Railway）

```bash
railway up
```

必要な環境変数：
- `DATABASE_URL`
- `NEXTAUTH_URL`
- `NEXTAUTH_SECRET`

## 開発メモ

<!-- 開発中のメモをここに追記 -->
