# Claude Code 開発ルール

## 🎯 このプロジェクトについて

**テンプレート種別**: API-Ready（スマホ拡張対応）

用途：将来スマホアプリにも展開予定のWebアプリ

このプロジェクトは：
- PC（Claude Desktop）とスマホ（Claudeアプリ）でシームレスに開発
- 将来のスマホアプリ（React Native等）と共通APIを使用
- Web/アプリ両対応の設計

---

## 📋 基本ルール

### ルール1：1セッション = 1機能

**必須：**
- 1回のセッションでは、1つの機能・タスクに集中する
- 複数の機能を依頼された場合は、優先順位を確認してから1つずつ対応

**例：**
```
❌ 悪い例：「認証と商品一覧と決済を作って」
✅ 良い例：「ユーザー一覧APIを作って。ページネーション付きで」
```

---

### ルール2：セッション終了前に必ずコミット

**作業完了時の手順：**
1. 変更内容を確認
2. 適切なコミットメッセージでコミット
3. リモートにプッシュ
4. ユーザーに完了報告

**コミットメッセージ規約：**
```
feat: 新機能追加
fix: バグ修正
docs: ドキュメント更新
style: コードスタイル修正
refactor: リファクタリング
test: テスト追加・修正
chore: その他（設定変更など）
api: API関連の変更
```

---

### ルール3：継続作業時のコンテキスト確認

スマホから継続する場合、または「続き」と言われた場合：

1. 現在のブランチとコミット履歴を確認
2. 直近の変更内容を要約して共有
3. 何を続けるか明確にしてから作業開始

**確認コマンド：**
```bash
git status
git log --oneline -5
```

---

### ルール4：API設計のルール

**重要：スマホアプリと共有するため、API設計は慎重に**

1. **バージョニング**: `/api/v1/` プレフィックスを使用
2. **RESTful**: 適切なHTTPメソッドとステータスコード
3. **レスポンス形式**: 統一されたJSON構造
4. **エラーハンドリング**: 一貫したエラーレスポンス

**レスポンス形式：**
```json
// 成功時
{
  "success": true,
  "data": { ... }
}

// エラー時
{
  "success": false,
  "error": {
    "code": "ERROR_CODE",
    "message": "エラーメッセージ"
  }
}
```

---

### ルール5：データベース変更時の注意

**Prismaスキーマを変更した場合：**
```bash
# マイグレーション作成
npx prisma migrate dev --name 変更内容

# クライアント再生成
npx prisma generate
```

**本番環境への反映：**
```bash
npx prisma migrate deploy
```

---

## 🛠️ 技術スタック

- **フレームワーク**: Next.js 14+ (App Router)
- **言語**: TypeScript
- **スタイリング**: Tailwind CSS
- **データベース**: PostgreSQL (Railway)
- **ORM**: Prisma
- **認証**: NextAuth.js v5 (Auth.js) + JWT
- **デプロイ**: Railway

---

## 📁 プロジェクト構造

```
src/
├── app/
│   ├── api/
│   │   ├── auth/        # NextAuth.js API
│   │   └── v1/          # バージョン管理されたAPI ★
│   │       ├── users/
│   │       ├── posts/
│   │       └── ...
│   ├── (auth)/          # 認証ページ
│   └── (main)/          # メインページ
├── components/
│   ├── ui/              # 汎用UIパーツ
│   └── features/        # 機能別コンポーネント
├── lib/
│   ├── db.ts            # Prismaクライアント
│   ├── auth.ts          # NextAuth設定
│   └── api-response.ts  # API共通レスポンス ★
└── types/               # 型定義（Web/アプリ共有可能）★

prisma/
├── schema.prisma
└── migrations/
```

---

## 🚀 開発コマンド

```bash
# 開発サーバー起動
npm run dev

# データベース操作
npx prisma studio        # DB管理画面
npx prisma migrate dev   # マイグレーション実行
npx prisma generate      # クライアント生成

# ビルド・デプロイ
npm run build            # 本番ビルド
```

---

## ⚙️ 環境変数

`.env.example` を `.env` にコピー：

```bash
cp .env.example .env
```

**必要な環境変数：**
- `DATABASE_URL` - PostgreSQL接続URL
- `NEXTAUTH_URL` - アプリのURL
- `NEXTAUTH_SECRET` - 認証用シークレット

---

## 📱 PC/スマホ連携

- **PC（Claude Desktop）**: API設計、DB設計、複雑な機能
- **スマホ**: UI修正、バグ修正、軽微な変更

**重要**: セッション切り替え前に必ず `git push` すること！

---

## 📲 スマホアプリ拡張時

将来React Native等でスマホアプリを作る場合：

1. `/api/v1/` のAPIをそのまま使用
2. `src/types/` の型定義を共有可能
3. 認証はJWTトークンで連携

**アーキテクチャ：**
```
┌─────────────┐     ┌─────────────┐
│   Web App   │     │ Mobile App  │
│  (Next.js)  │     │(React Native)│
└──────┬──────┘     └──────┬──────┘
       │                   │
       └───────┬───────────┘
               │
        ┌──────▼──────┐
        │   /api/v1/   │
        │  (共通API)   │
        └──────┬──────┘
               │
        ┌──────▼──────┐
        │ PostgreSQL  │
        └─────────────┘
```
